//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
template <typename T>
class C_TreeNode
{
    private :
//+----------------+
        T           info;
        C_TreeNode  *left,
                    *right;
//+----------------+
    public  :
//+----------------+
        C_TreeNode(T arg)
            :left(NULL),
            right(NULL),
            info(arg)
        {}
//+----------------+
        void SetLeft(C_TreeNode *ptr) { left = ptr; }
//+----------------+
        void SetRight(C_TreeNode *ptr) { right = ptr; }
//+----------------+
        T GetInfo(void) const { return info; }
//+----------------+
        C_TreeNode *GetLeft(void) const { return left; }
//+----------------+
        C_TreeNode *GetRight(void) const { return right; }
//+----------------+
};
//+------------------------------------------------------------------+
#define C_TreeNode C_TreeNode<T>
template <typename T>
class C_Tree
{
//+----------------+
    #define def_InfoToString(A) (A != NULL ? StringFormat("%d ", (*A).GetInfo()) : "")
    enum E_SEQ {eInOrder, ePreOrder, ePostOrder, eDestroy};
//+----------------+
    private :
        C_TreeNode *root;
        string      m_szInfo;
//+----------------+
        int countL(C_TreeNode *ptr)
        {
            int count = 0;

            while ((*ptr).GetLeft() != NULL)
            {
                ptr = (*ptr).GetLeft();
                count++;
                if (((*ptr).GetLeft() == NULL)&&((*ptr).GetRight() != NULL)) while ((*ptr).GetRight() != NULL)
                {
                    ptr = (*ptr).GetRight();
                    count++;
                }
            }

            return count;
        }
//+----------------+
        int countR(C_TreeNode *ptr)
        {
            int count = 0;

            while ((*ptr).GetRight() != NULL)
            {
                ptr = (*ptr).GetRight();
                count++;
                if (((*ptr).GetRight() == NULL)&&((*ptr).GetLeft() != NULL)) while ((*ptr).GetLeft() != NULL)
                {
                    ptr = (*ptr).GetLeft();
                    count++;
                }
            }

            return count;
        }
//+----------------+
        C_TreeNode *Insert(C_TreeNode *ptr, T info)
        {
            if (ptr == NULL)
                return new C_TreeNode(info);

            if (info < (*ptr).GetInfo()) (*ptr).SetLeft(Insert((*ptr).GetLeft(), info));
            else (*ptr).SetRight(Insert((*ptr).GetRight(), info));

            return ptr;
        }
//+----------------+
        void Seq(C_TreeNode *ptr, const E_SEQ type)
        {
            if (ptr == NULL) return;

            switch (type)
            {
                case eInOrder   :
                case ePostOrder :
                case eDestroy   :
                    Seq((*ptr).GetLeft(), type);
                    if (type == eInOrder) break;
                    Seq((*ptr).GetRight(), type);
            }
            m_szInfo += def_InfoToString(ptr);
            switch (type)
            {
                case ePreOrder  :
                    Seq((*ptr).GetLeft(), type);
                case eInOrder   :
                    Seq((*ptr).GetRight(), type);
                    break;
                case eDestroy   :
                    delete ptr;
            }
        }
//+----------------+
    public  :
//+----------------+
        C_Tree()
            :root(NULL)
        {}
//+----------------+
        ~C_Tree()
        {
            Seq(root, eDestroy);
        }
//+----------------+
        void Store(T info)
        {
            if (root == NULL) root = Insert(root, info);
            else Insert(root, info);
        }
//+----------------+
        void CheckBalance(void)
        {
            Print("Balance: ", countR(root) - countL(root));
        }
//+----------------+
        string In_Order(void)
        {
            m_szInfo = "In Order: ";
            Seq(root, eInOrder);
            
            return m_szInfo;
        }
//+----------------+
        string Pre_Order(void)
        {
            m_szInfo = "Pre Order: ";
            Seq(root, ePreOrder);

            return m_szInfo;
        }
//+----------------+
        string Post_Order(void)
        {
            m_szInfo = "Post Order: ";
            Seq(root, ePostOrder);

            return m_szInfo;
        }
//+----------------+
    #undef def_InfoToString
//+----------------+
};
#undef C_TreeNode
//+------------------------------------------------------------------+
void OnStart(void)
{
    C_Tree <int> Tree;

    Tree.Store(10);
    Tree.Store(-6);
    Tree.Store(47);
    Tree.Store(35);
    Tree.Store(51);
    Tree.Store(90);
    Tree.Store(85);
    Tree.Store(40);

    Print(Tree.In_Order());
    Print(Tree.Pre_Order());
    Print(Tree.Post_Order());
    
    Tree.CheckBalance();
}
//+------------------------------------------------------------------+